package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Importance height. */
public final class ImportanceHeightDto implements Serializer {
    /** Importance height. */
    private final long importanceHeight;

    /**
     * Constructor.
     *
     * @param importanceHeight Importance height.
     */
    public ImportanceHeightDto(final long importanceHeight) {
        this.importanceHeight = importanceHeight;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public ImportanceHeightDto(final DataInputStream stream) {
        try {
            this.importanceHeight = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Importance height.
     *
     * @return Importance height.
     */
    public long getImportanceHeight() {
        return this.importanceHeight;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of ImportanceHeightDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of ImportanceHeightDto.
     */
    public static ImportanceHeightDto loadFromBinary(final DataInputStream stream) {
        return new ImportanceHeightDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getImportanceHeight()));
        });
    }
}

