package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Importance. */
public final class ImportanceDto implements Serializer {
    /** Importance. */
    private final long importance;

    /**
     * Constructor.
     *
     * @param importance Importance.
     */
    public ImportanceDto(final long importance) {
        this.importance = importance;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public ImportanceDto(final DataInputStream stream) {
        try {
            this.importance = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Importance.
     *
     * @return Importance.
     */
    public long getImportance() {
        return this.importance;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of ImportanceDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of ImportanceDto.
     */
    public static ImportanceDto loadFromBinary(final DataInputStream stream) {
        return new ImportanceDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getImportance()));
        });
    }
}

