package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Difficulty. */
public final class DifficultyDto implements Serializer {
    /** Difficulty. */
    private final long difficulty;

    /**
     * Constructor.
     *
     * @param difficulty Difficulty.
     */
    public DifficultyDto(final long difficulty) {
        this.difficulty = difficulty;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public DifficultyDto(final DataInputStream stream) {
        try {
            this.difficulty = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Difficulty.
     *
     * @return Difficulty.
     */
    public long getDifficulty() {
        return this.difficulty;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of DifficultyDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of DifficultyDto.
     */
    public static DifficultyDto loadFromBinary(final DataInputStream stream) {
        return new DifficultyDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getDifficulty()));
        });
    }
}

