/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum ReceiptTypeDto implements Serializer
{
    RESERVED(0),
    MOSAIC_RENTAL_FEE(4685),
    NAMESPACE_RENTAL_FEE(4942),
    HARVEST_FEE(8515),
    LOCK_HASH_COMPLETED(8776),
    LOCK_HASH_EXPIRED(9032),
    LOCK_SECRET_COMPLETED(8786),
    LOCK_SECRET_EXPIRED(9042),
    LOCK_HASH_CREATED(12616),
    LOCK_SECRET_CREATED(12626),
    MOSAIC_EXPIRED(16717),
    NAMESPACE_EXPIRED(16718),
    NAMESPACE_DELETED(16974),
    INFLATION(20803),
    TRANSACTION_GROUP(-7869),
    ADDRESS_ALIAS_RESOLUTION(-3773),
    MOSAIC_ALIAS_RESOLUTION(-3517);

    private final short value;

    private ReceiptTypeDto(short value) {
        this.value = value;
    }

    public static ReceiptTypeDto rawValueOf(short value) {
        for (ReceiptTypeDto current : ReceiptTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for ReceiptTypeDto.");
    }

    @Override
    public int getSize() {
        return 2;
    }

    public short getValue() {
        return this.value;
    }

    public static ReceiptTypeDto loadFromBinary(DataInputStream stream) {
        try {
            short streamValue = Short.reverseBytes(stream.readShort());
            return ReceiptTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeShort(Short.reverseBytes(this.value)));
    }
}

