package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Scoped metadata key. */
public final class ScopedMetadataKeyDto implements Serializer {
    /** Scoped metadata key. */
    private final long scopedMetadataKey;

    /**
     * Constructor.
     *
     * @param scopedMetadataKey Scoped metadata key.
     */
    public ScopedMetadataKeyDto(final long scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public ScopedMetadataKeyDto(final DataInputStream stream) {
        try {
            this.scopedMetadataKey = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Scoped metadata key.
     *
     * @return Scoped metadata key.
     */
    public long getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of ScopedMetadataKeyDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of ScopedMetadataKeyDto.
     */
    public static ScopedMetadataKeyDto loadFromBinary(final DataInputStream stream) {
        return new ScopedMetadataKeyDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getScopedMetadataKey()));
        });
    }
}

