package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Proof gamma. */
public final class ProofGammaDto implements Serializer {
    /** Proof gamma. */
    private final ByteBuffer proofGamma;

    /**
     * Constructor.
     *
     * @param proofGamma Proof gamma.
     */
    public ProofGammaDto(final ByteBuffer proofGamma) {
        this.proofGamma = proofGamma;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public ProofGammaDto(final DataInputStream stream) {
        try {
            this.proofGamma = GeneratorUtils.readByteBuffer(stream, 32);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Proof gamma.
     *
     * @return Proof gamma.
     */
    public ByteBuffer getProofGamma() {
        return this.proofGamma;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 32;
    }

    /**
     * Creates an instance of ProofGammaDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of ProofGammaDto.
     */
    public static ProofGammaDto loadFromBinary(final DataInputStream stream) {
        return new ProofGammaDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.proofGamma.array(), 0, this.proofGamma.array().length);
        });
    }
}

