package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;

/**
* Enumeration of mosaic restriction types
**/
public enum MosaicRestrictionTypeDto implements Serializer {

    /** uninitialized value indicating no restriction. */
    NONE((byte) 0),

    /** allow if equal. */
    EQ((byte) 1),

    /** allow if not equal. */
    NE((byte) 2),

    /** allow if less than. */
    LT((byte) 3),

    /** allow if less than or equal. */
    LE((byte) 4),

    /** allow if greater than. */
    GT((byte) 5),

    /** allow if greater than or equal. */
    GE((byte) 6);


    /** Enum value. */
    private final byte value;

    /**
     * Constructor.
     *
     * @param value Enum value.
     */
     MosaicRestrictionTypeDto(final byte value) {
        this.value = value;
    }

    /**
     * Gets enum value.
     *
     * @param value Raw value of the enum.
     * @return Enum value.
     */
    public static MosaicRestrictionTypeDto rawValueOf(final byte value) {
        for (MosaicRestrictionTypeDto current : MosaicRestrictionTypeDto.values()) {
            if (value == current.value) {
                return current;
            }
        }
        throw new IllegalArgumentException(value + " was not a backing value for MosaicRestrictionTypeDto.");
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 1;
    }

    /**
     * Gets the value of the enum.
     *
     * @return Value of the enum.
     */
    public byte getValue() {
        return this.value;
    }
    /**
     * Creates an instance of MosaicRestrictionTypeDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of MosaicRestrictionTypeDto.
     */
    public static MosaicRestrictionTypeDto loadFromBinary(final DataInputStream stream) {
        try {
            final byte streamValue = stream.readByte();
            return rawValueOf(streamValue);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte(this.value);
        });
    }
}

