package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;

/**
* Enum for the different types of metadata
**/
public enum MetadataTypeDto implements Serializer {

    /** account metadata. */
    ACCOUNT((byte) 0),

    /** mosaic metadata. */
    MOSAIC((byte) 1),

    /** namespace metadata. */
    NAMESPACE((byte) 2);


    /** Enum value. */
    private final byte value;

    /**
     * Constructor.
     *
     * @param value Enum value.
     */
     MetadataTypeDto(final byte value) {
        this.value = value;
    }

    /**
     * Gets enum value.
     *
     * @param value Raw value of the enum.
     * @return Enum value.
     */
    public static MetadataTypeDto rawValueOf(final byte value) {
        for (MetadataTypeDto current : MetadataTypeDto.values()) {
            if (value == current.value) {
                return current;
            }
        }
        throw new IllegalArgumentException(value + " was not a backing value for MetadataTypeDto.");
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 1;
    }

    /**
     * Gets the value of the enum.
     *
     * @return Value of the enum.
     */
    public byte getValue() {
        return this.value;
    }
    /**
     * Creates an instance of MetadataTypeDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of MetadataTypeDto.
     */
    public static MetadataTypeDto loadFromBinary(final DataInputStream stream) {
        try {
            final byte streamValue = stream.readByte();
            return rawValueOf(streamValue);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte(this.value);
        });
    }
}

