package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Hash512. */
public final class Hash512Dto implements Serializer {
    /** Hash512. */
    private final ByteBuffer hash512;

    /**
     * Constructor.
     *
     * @param hash512 Hash512.
     */
    public Hash512Dto(final ByteBuffer hash512) {
        this.hash512 = hash512;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public Hash512Dto(final DataInputStream stream) {
        try {
            this.hash512 = GeneratorUtils.readByteBuffer(stream, 64);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Hash512.
     *
     * @return Hash512.
     */
    public ByteBuffer getHash512() {
        return this.hash512;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 64;
    }

    /**
     * Creates an instance of Hash512Dto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of Hash512Dto.
     */
    public static Hash512Dto loadFromBinary(final DataInputStream stream) {
        return new Hash512Dto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.hash512.array(), 0, this.hash512.array().length);
        });
    }
}

