package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Hash256. */
public final class Hash256Dto implements Serializer {
    /** Hash256. */
    private final ByteBuffer hash256;

    /**
     * Constructor.
     *
     * @param hash256 Hash256.
     */
    public Hash256Dto(final ByteBuffer hash256) {
        this.hash256 = hash256;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public Hash256Dto(final DataInputStream stream) {
        try {
            this.hash256 = GeneratorUtils.readByteBuffer(stream, 32);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Hash256.
     *
     * @return Hash256.
     */
    public ByteBuffer getHash256() {
        return this.hash256;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 32;
    }

    /**
     * Creates an instance of Hash256Dto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of Hash256Dto.
     */
    public static Hash256Dto loadFromBinary(final DataInputStream stream) {
        return new Hash256Dto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.hash256.array(), 0, this.hash256.array().length);
        });
    }
}

