package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Finalization point. */
public final class FinalizationPointDto implements Serializer {
    /** Finalization point. */
    private final int finalizationPoint;

    /**
     * Constructor.
     *
     * @param finalizationPoint Finalization point.
     */
    public FinalizationPointDto(final int finalizationPoint) {
        this.finalizationPoint = finalizationPoint;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public FinalizationPointDto(final DataInputStream stream) {
        try {
            this.finalizationPoint = Integer.reverseBytes(stream.readInt());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Finalization point.
     *
     * @return Finalization point.
     */
    public int getFinalizationPoint() {
        return this.finalizationPoint;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 4;
    }

    /**
     * Creates an instance of FinalizationPointDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of FinalizationPointDto.
     */
    public static FinalizationPointDto loadFromBinary(final DataInputStream stream) {
        return new FinalizationPointDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getFinalizationPoint()));
        });
    }
}

