package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Finalization epoch. */
public final class FinalizationEpochDto implements Serializer {
    /** Finalization epoch. */
    private final int finalizationEpoch;

    /**
     * Constructor.
     *
     * @param finalizationEpoch Finalization epoch.
     */
    public FinalizationEpochDto(final int finalizationEpoch) {
        this.finalizationEpoch = finalizationEpoch;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public FinalizationEpochDto(final DataInputStream stream) {
        try {
            this.finalizationEpoch = Integer.reverseBytes(stream.readInt());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Finalization epoch.
     *
     * @return Finalization epoch.
     */
    public int getFinalizationEpoch() {
        return this.finalizationEpoch;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 4;
    }

    /**
     * Creates an instance of FinalizationEpochDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of FinalizationEpochDto.
     */
    public static FinalizationEpochDto loadFromBinary(final DataInputStream stream) {
        return new FinalizationEpochDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getFinalizationEpoch()));
        });
    }
}

