package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Block fee multiplier. */
public final class BlockFeeMultiplierDto implements Serializer {
    /** Block fee multiplier. */
    private final int blockFeeMultiplier;

    /**
     * Constructor.
     *
     * @param blockFeeMultiplier Block fee multiplier.
     */
    public BlockFeeMultiplierDto(final int blockFeeMultiplier) {
        this.blockFeeMultiplier = blockFeeMultiplier;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public BlockFeeMultiplierDto(final DataInputStream stream) {
        try {
            this.blockFeeMultiplier = Integer.reverseBytes(stream.readInt());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Block fee multiplier.
     *
     * @return Block fee multiplier.
     */
    public int getBlockFeeMultiplier() {
        return this.blockFeeMultiplier;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 4;
    }

    /**
     * Creates an instance of BlockFeeMultiplierDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of BlockFeeMultiplierDto.
     */
    public static BlockFeeMultiplierDto loadFromBinary(final DataInputStream stream) {
        return new BlockFeeMultiplierDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getBlockFeeMultiplier()));
        });
    }
}

