package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;

/**
* Enumeration of account restriction flags
**/
public enum AccountRestrictionFlagsDto implements BitMaskable, Serializer {

    /** restriction type is an address. */
    ADDRESS((short) 1),

    /** restriction type is a mosaic identifier. */
    MOSAIC_ID((short) 2),

    /** restriction type is a transaction type. */
    TRANSACTION_TYPE((short) 4),

    /** restriction is interpreted as outgoing. */
    OUTGOING((short) 16384),

    /** restriction is interpreted as blocking (instead of allowing) operation. */
    BLOCK((short) 32768);


    /** Enum value. */
    private final short value;

    /**
     * Constructor.
     *
     * @param value Enum value.
     */
     AccountRestrictionFlagsDto(final short value) {
        this.value = value;
    }

    /**
     * Gets enum value.
     *
     * @param value Raw value of the enum.
     * @return Enum value.
     */
    public static AccountRestrictionFlagsDto rawValueOf(final short value) {
        for (AccountRestrictionFlagsDto current : AccountRestrictionFlagsDto.values()) {
            if (value == current.value) {
                return current;
            }
        }
        throw new IllegalArgumentException(value + " was not a backing value for AccountRestrictionFlagsDto.");
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 2;
    }

    /**
     * Gets the value of the enum.
     *
     * @return Value of the enum.
     */
    public short getValue() {
        return this.value;
    }
    /**
     * Gets the value of the enum.
     *
     * @return Value of the enum.
     */
    public long getValueAsLong() {
        return GeneratorUtils.toUnsignedInt(this.value);
    }

    /**
     * Creates an instance of AccountRestrictionFlagsDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of AccountRestrictionFlagsDto.
     */
    public static AccountRestrictionFlagsDto loadFromBinary(final DataInputStream stream) {
        try {
            final short streamValue = Short.reverseBytes(stream.readShort());
            return rawValueOf(streamValue);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeShort(Short.reverseBytes(this.value));
        });
    }
}

