/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum MetadataTypeDto implements Serializer
{
    ACCOUNT(0),
    MOSAIC(1),
    NAMESPACE(2);

    private final byte value;

    private MetadataTypeDto(byte value) {
        this.value = value;
    }

    public static MetadataTypeDto rawValueOf(byte value) {
        for (MetadataTypeDto current : MetadataTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for MetadataTypeDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    public static MetadataTypeDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return MetadataTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

