/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class BlockDurationDto
implements Serializer {
    private final long blockDuration;

    public BlockDurationDto(long blockDuration) {
        this.blockDuration = blockDuration;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public BlockDurationDto(DataInputStream stream) {
        try {
            this.blockDuration = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public long getBlockDuration() {
        return this.blockDuration;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static BlockDurationDto loadFromBinary(DataInputStream stream) {
        return new BlockDurationDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getBlockDuration())));
    }
}

