/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class BalanceTransferReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final MosaicBuilder mosaic;
    private final AddressDto senderAddress;
    private final AddressDto recipientAddress;

    protected BalanceTransferReceiptBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.mosaic = MosaicBuilder.loadFromBinary(stream);
            this.senderAddress = AddressDto.loadFromBinary(stream);
            this.recipientAddress = AddressDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static BalanceTransferReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new BalanceTransferReceiptBuilder(stream);
    }

    protected BalanceTransferReceiptBuilder(short version, ReceiptTypeDto type, MosaicBuilder mosaic, AddressDto senderAddress, AddressDto recipientAddress) {
        super(version, type);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(senderAddress, "senderAddress is null", new Object[0]);
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        this.mosaic = mosaic;
        this.senderAddress = senderAddress;
        this.recipientAddress = recipientAddress;
    }

    public static BalanceTransferReceiptBuilder create(short version, ReceiptTypeDto type, MosaicBuilder mosaic, AddressDto senderAddress, AddressDto recipientAddress) {
        return new BalanceTransferReceiptBuilder(version, type, mosaic, senderAddress, recipientAddress);
    }

    public MosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public AddressDto getSenderAddress() {
        return this.senderAddress;
    }

    public AddressDto getRecipientAddress() {
        return this.recipientAddress;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.mosaic.getSize();
        size += this.senderAddress.getSize();
        return size += this.recipientAddress.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
            GeneratorUtils.writeEntity(dataOutputStream, this.senderAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.recipientAddress);
        });
    }
}

