/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class AccountRestrictionAddressValueBuilder
implements Serializer {
    private final List<AddressDto> restrictionValues;

    protected AccountRestrictionAddressValueBuilder(DataInputStream stream) {
        try {
            long restrictionValuesCount = Long.reverseBytes(stream.readLong());
            this.restrictionValues = GeneratorUtils.loadFromBinaryArray(AddressDto::loadFromBinary, stream, restrictionValuesCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountRestrictionAddressValueBuilder loadFromBinary(DataInputStream stream) {
        return new AccountRestrictionAddressValueBuilder(stream);
    }

    protected AccountRestrictionAddressValueBuilder(List<AddressDto> restrictionValues) {
        GeneratorUtils.notNull(restrictionValues, "restrictionValues is null", new Object[0]);
        this.restrictionValues = restrictionValues;
    }

    public static AccountRestrictionAddressValueBuilder create(List<AddressDto> restrictionValues) {
        return new AccountRestrictionAddressValueBuilder(restrictionValues);
    }

    public List<AddressDto> getRestrictionValues() {
        return this.restrictionValues;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 8;
        return size += this.restrictionValues.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getRestrictionValues())));
            GeneratorUtils.writeList(dataOutputStream, this.restrictionValues);
        });
    }
}

