/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class SignatureDto
implements Serializer {
    private final ByteBuffer signature;

    public SignatureDto(ByteBuffer signature) {
        this.signature = signature;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public SignatureDto(DataInputStream stream) {
        try {
            this.signature = GeneratorUtils.readByteBuffer(stream, 64);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public ByteBuffer getSignature() {
        return this.signature;
    }

    @Override
    public int getSize() {
        return 64;
    }

    public static SignatureDto loadFromBinary(DataInputStream stream) {
        return new SignatureDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.signature.array(), 0, this.signature.array().length));
    }
}

