/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class ReceiptBuilder
implements Serializer {
    private int size;
    private final short version;
    private final ReceiptTypeDto type;

    protected ReceiptBuilder(DataInputStream stream) {
        try {
            this.size = Integer.reverseBytes(stream.readInt());
            this.version = Short.reverseBytes(stream.readShort());
            this.type = ReceiptTypeDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static ReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new ReceiptBuilder(stream);
    }

    protected ReceiptBuilder(short version, ReceiptTypeDto type) {
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        this.version = version;
        this.type = type;
    }

    public static ReceiptBuilder create(short version, ReceiptTypeDto type) {
        return new ReceiptBuilder(version, type);
    }

    public int getStreamSize() {
        return this.size;
    }

    public short getVersion() {
        return this.version;
    }

    public ReceiptTypeDto getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 2;
        return size += this.type.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeShort(Short.reverseBytes(this.getVersion()));
            GeneratorUtils.writeEntity(dataOutputStream, this.type);
        });
    }
}

