/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class MosaicIdDto
implements Serializer {
    private final long mosaicId;

    public MosaicIdDto(long mosaicId) {
        this.mosaicId = mosaicId;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public MosaicIdDto(DataInputStream stream) {
        try {
            this.mosaicId = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public long getMosaicId() {
        return this.mosaicId;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static MosaicIdDto loadFromBinary(DataInputStream stream) {
        return new MosaicIdDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getMosaicId())));
    }
}

