/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.MosaicPropertiesBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicDefinitionBuilder
implements Serializer {
    private final HeightDto startHeight;
    private final AddressDto ownerAddress;
    private final int revision;
    private final MosaicPropertiesBuilder properties;

    protected MosaicDefinitionBuilder(DataInputStream stream) {
        try {
            this.startHeight = HeightDto.loadFromBinary(stream);
            this.ownerAddress = AddressDto.loadFromBinary(stream);
            this.revision = Integer.reverseBytes(stream.readInt());
            this.properties = MosaicPropertiesBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicDefinitionBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicDefinitionBuilder(stream);
    }

    protected MosaicDefinitionBuilder(HeightDto startHeight, AddressDto ownerAddress, int revision, MosaicPropertiesBuilder properties) {
        GeneratorUtils.notNull(startHeight, "startHeight is null", new Object[0]);
        GeneratorUtils.notNull(ownerAddress, "ownerAddress is null", new Object[0]);
        GeneratorUtils.notNull(revision, "revision is null", new Object[0]);
        GeneratorUtils.notNull(properties, "properties is null", new Object[0]);
        this.startHeight = startHeight;
        this.ownerAddress = ownerAddress;
        this.revision = revision;
        this.properties = properties;
    }

    public static MosaicDefinitionBuilder create(HeightDto startHeight, AddressDto ownerAddress, int revision, MosaicPropertiesBuilder properties) {
        return new MosaicDefinitionBuilder(startHeight, ownerAddress, revision, properties);
    }

    public HeightDto getStartHeight() {
        return this.startHeight;
    }

    public AddressDto getOwnerAddress() {
        return this.ownerAddress;
    }

    public int getRevision() {
        return this.revision;
    }

    public MosaicPropertiesBuilder getProperties() {
        return this.properties;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.startHeight.getSize();
        size += this.ownerAddress.getSize();
        size += 4;
        return size += this.properties.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.startHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.ownerAddress);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getRevision()));
            GeneratorUtils.writeEntity(dataOutputStream, this.properties);
        });
    }
}

