/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class ImportanceDto
implements Serializer {
    private final long importance;

    public ImportanceDto(long importance) {
        this.importance = importance;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public ImportanceDto(DataInputStream stream) {
        try {
            this.importance = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public long getImportance() {
        return this.importance;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static ImportanceDto loadFromBinary(DataInputStream stream) {
        return new ImportanceDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getImportance())));
    }
}

