/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class ImportanceBlockFooterBuilder
implements Serializer {
    private final int votingEligibleAccountsCount;
    private final long harvestingEligibleAccountsCount;
    private final AmountDto totalVotingBalance;
    private final Hash256Dto previousImportanceBlockHash;

    protected ImportanceBlockFooterBuilder(DataInputStream stream) {
        try {
            this.votingEligibleAccountsCount = Integer.reverseBytes(stream.readInt());
            this.harvestingEligibleAccountsCount = Long.reverseBytes(stream.readLong());
            this.totalVotingBalance = AmountDto.loadFromBinary(stream);
            this.previousImportanceBlockHash = Hash256Dto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static ImportanceBlockFooterBuilder loadFromBinary(DataInputStream stream) {
        return new ImportanceBlockFooterBuilder(stream);
    }

    protected ImportanceBlockFooterBuilder(int votingEligibleAccountsCount, long harvestingEligibleAccountsCount, AmountDto totalVotingBalance, Hash256Dto previousImportanceBlockHash) {
        GeneratorUtils.notNull(votingEligibleAccountsCount, "votingEligibleAccountsCount is null", new Object[0]);
        GeneratorUtils.notNull(harvestingEligibleAccountsCount, "harvestingEligibleAccountsCount is null", new Object[0]);
        GeneratorUtils.notNull(totalVotingBalance, "totalVotingBalance is null", new Object[0]);
        GeneratorUtils.notNull(previousImportanceBlockHash, "previousImportanceBlockHash is null", new Object[0]);
        this.votingEligibleAccountsCount = votingEligibleAccountsCount;
        this.harvestingEligibleAccountsCount = harvestingEligibleAccountsCount;
        this.totalVotingBalance = totalVotingBalance;
        this.previousImportanceBlockHash = previousImportanceBlockHash;
    }

    public static ImportanceBlockFooterBuilder create(int votingEligibleAccountsCount, long harvestingEligibleAccountsCount, AmountDto totalVotingBalance, Hash256Dto previousImportanceBlockHash) {
        return new ImportanceBlockFooterBuilder(votingEligibleAccountsCount, harvestingEligibleAccountsCount, totalVotingBalance, previousImportanceBlockHash);
    }

    public int getVotingEligibleAccountsCount() {
        return this.votingEligibleAccountsCount;
    }

    public long getHarvestingEligibleAccountsCount() {
        return this.harvestingEligibleAccountsCount;
    }

    public AmountDto getTotalVotingBalance() {
        return this.totalVotingBalance;
    }

    public Hash256Dto getPreviousImportanceBlockHash() {
        return this.previousImportanceBlockHash;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 8;
        size += this.totalVotingBalance.getSize();
        return size += this.previousImportanceBlockHash.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getVotingEligibleAccountsCount()));
            dataOutputStream.writeLong(Long.reverseBytes(this.getHarvestingEligibleAccountsCount()));
            GeneratorUtils.writeEntity(dataOutputStream, this.totalVotingBalance);
            GeneratorUtils.writeEntity(dataOutputStream, this.previousImportanceBlockHash);
        });
    }
}

