/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.FinalizationEpochDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.VotingKeyLinkV1TransactionBodyBuilder;
import io.nem.symbol.catapult.builders.VotingKeyV1Dto;
import java.io.DataInputStream;

public class EmbeddedVotingKeyLinkV1TransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final VotingKeyLinkV1TransactionBodyBuilder votingKeyLinkV1TransactionBody;

    protected EmbeddedVotingKeyLinkV1TransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.votingKeyLinkV1TransactionBody = VotingKeyLinkV1TransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedVotingKeyLinkV1TransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedVotingKeyLinkV1TransactionBuilder(stream);
    }

    protected EmbeddedVotingKeyLinkV1TransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, VotingKeyV1Dto linkedPublicKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch, LinkActionDto linkAction) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(startEpoch, "startEpoch is null", new Object[0]);
        GeneratorUtils.notNull(endEpoch, "endEpoch is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.votingKeyLinkV1TransactionBody = new VotingKeyLinkV1TransactionBodyBuilder(linkedPublicKey, startEpoch, endEpoch, linkAction);
    }

    public static EmbeddedVotingKeyLinkV1TransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, VotingKeyV1Dto linkedPublicKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch, LinkActionDto linkAction) {
        return new EmbeddedVotingKeyLinkV1TransactionBuilder(signerPublicKey, version, network, type, linkedPublicKey, startEpoch, endEpoch, linkAction);
    }

    public VotingKeyV1Dto getLinkedPublicKey() {
        return this.votingKeyLinkV1TransactionBody.getLinkedPublicKey();
    }

    public FinalizationEpochDto getStartEpoch() {
        return this.votingKeyLinkV1TransactionBody.getStartEpoch();
    }

    public FinalizationEpochDto getEndEpoch() {
        return this.votingKeyLinkV1TransactionBody.getEndEpoch();
    }

    public LinkActionDto getLinkAction() {
        return this.votingKeyLinkV1TransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.votingKeyLinkV1TransactionBody.getSize();
    }

    @Override
    public VotingKeyLinkV1TransactionBodyBuilder getBody() {
        return this.votingKeyLinkV1TransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.votingKeyLinkV1TransactionBody);
        });
    }
}

