/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.FinalizationEpochDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.VotingKeyV1Dto;
import java.io.DataInputStream;

public class VotingKeyLinkV1TransactionBodyBuilder
implements Serializer {
    private final VotingKeyV1Dto linkedPublicKey;
    private final FinalizationEpochDto startEpoch;
    private final FinalizationEpochDto endEpoch;
    private final LinkActionDto linkAction;

    protected VotingKeyLinkV1TransactionBodyBuilder(DataInputStream stream) {
        try {
            this.linkedPublicKey = VotingKeyV1Dto.loadFromBinary(stream);
            this.startEpoch = FinalizationEpochDto.loadFromBinary(stream);
            this.endEpoch = FinalizationEpochDto.loadFromBinary(stream);
            this.linkAction = LinkActionDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static VotingKeyLinkV1TransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new VotingKeyLinkV1TransactionBodyBuilder(stream);
    }

    protected VotingKeyLinkV1TransactionBodyBuilder(VotingKeyV1Dto linkedPublicKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch, LinkActionDto linkAction) {
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(startEpoch, "startEpoch is null", new Object[0]);
        GeneratorUtils.notNull(endEpoch, "endEpoch is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.startEpoch = startEpoch;
        this.endEpoch = endEpoch;
        this.linkAction = linkAction;
    }

    public static VotingKeyLinkV1TransactionBodyBuilder create(VotingKeyV1Dto linkedPublicKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch, LinkActionDto linkAction) {
        return new VotingKeyLinkV1TransactionBodyBuilder(linkedPublicKey, startEpoch, endEpoch, linkAction);
    }

    public VotingKeyV1Dto getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public FinalizationEpochDto getStartEpoch() {
        return this.startEpoch;
    }

    public FinalizationEpochDto getEndEpoch() {
        return this.endEpoch;
    }

    public LinkActionDto getLinkAction() {
        return this.linkAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.linkedPublicKey.getSize();
        size += this.startEpoch.getSize();
        size += this.endEpoch.getSize();
        return size += this.linkAction.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.linkedPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.startEpoch);
            GeneratorUtils.writeEntity(dataOutputStream, this.endEpoch);
            GeneratorUtils.writeEntity(dataOutputStream, this.linkAction);
        });
    }
}

