/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class NamespaceLifetimeBuilder
implements Serializer {
    private final HeightDto lifetimeStart;
    private final HeightDto lifetimeEnd;

    protected NamespaceLifetimeBuilder(DataInputStream stream) {
        try {
            this.lifetimeStart = HeightDto.loadFromBinary(stream);
            this.lifetimeEnd = HeightDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NamespaceLifetimeBuilder loadFromBinary(DataInputStream stream) {
        return new NamespaceLifetimeBuilder(stream);
    }

    protected NamespaceLifetimeBuilder(HeightDto lifetimeStart, HeightDto lifetimeEnd) {
        GeneratorUtils.notNull(lifetimeStart, "lifetimeStart is null", new Object[0]);
        GeneratorUtils.notNull(lifetimeEnd, "lifetimeEnd is null", new Object[0]);
        this.lifetimeStart = lifetimeStart;
        this.lifetimeEnd = lifetimeEnd;
    }

    public static NamespaceLifetimeBuilder create(HeightDto lifetimeStart, HeightDto lifetimeEnd) {
        return new NamespaceLifetimeBuilder(lifetimeStart, lifetimeEnd);
    }

    public HeightDto getLifetimeStart() {
        return this.lifetimeStart;
    }

    public HeightDto getLifetimeEnd() {
        return this.lifetimeEnd;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.lifetimeStart.getSize();
        return size += this.lifetimeEnd.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.lifetimeStart);
            GeneratorUtils.writeEntity(dataOutputStream, this.lifetimeEnd);
        });
    }
}

