/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.ImportanceHeightDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class HeightActivityBucketBuilder
implements Serializer {
    private final ImportanceHeightDto startHeight;
    private final AmountDto totalFeesPaid;
    private final int beneficiaryCount;
    private final long rawScore;

    protected HeightActivityBucketBuilder(DataInputStream stream) {
        try {
            this.startHeight = ImportanceHeightDto.loadFromBinary(stream);
            this.totalFeesPaid = AmountDto.loadFromBinary(stream);
            this.beneficiaryCount = Integer.reverseBytes(stream.readInt());
            this.rawScore = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static HeightActivityBucketBuilder loadFromBinary(DataInputStream stream) {
        return new HeightActivityBucketBuilder(stream);
    }

    protected HeightActivityBucketBuilder(ImportanceHeightDto startHeight, AmountDto totalFeesPaid, int beneficiaryCount, long rawScore) {
        GeneratorUtils.notNull(startHeight, "startHeight is null", new Object[0]);
        GeneratorUtils.notNull(totalFeesPaid, "totalFeesPaid is null", new Object[0]);
        GeneratorUtils.notNull(beneficiaryCount, "beneficiaryCount is null", new Object[0]);
        GeneratorUtils.notNull(rawScore, "rawScore is null", new Object[0]);
        this.startHeight = startHeight;
        this.totalFeesPaid = totalFeesPaid;
        this.beneficiaryCount = beneficiaryCount;
        this.rawScore = rawScore;
    }

    public static HeightActivityBucketBuilder create(ImportanceHeightDto startHeight, AmountDto totalFeesPaid, int beneficiaryCount, long rawScore) {
        return new HeightActivityBucketBuilder(startHeight, totalFeesPaid, beneficiaryCount, rawScore);
    }

    public ImportanceHeightDto getStartHeight() {
        return this.startHeight;
    }

    public AmountDto getTotalFeesPaid() {
        return this.totalFeesPaid;
    }

    public int getBeneficiaryCount() {
        return this.beneficiaryCount;
    }

    public long getRawScore() {
        return this.rawScore;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.startHeight.getSize();
        size += this.totalFeesPaid.getSize();
        size += 4;
        return size += 8;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.startHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.totalFeesPaid);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getBeneficiaryCount()));
            dataOutputStream.writeLong(Long.reverseBytes(this.getRawScore()));
        });
    }
}

