/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum EntityTypeDto implements Serializer
{
    RESERVED(0),
    NEMESIS_BLOCK_HEADER(-32701),
    NORMAL_BLOCK_HEADER(-32445),
    IMPORTANCE_BLOCK_HEADER(-32189),
    ACCOUNT_KEY_LINK_TRANSACTION(16716),
    NODE_KEY_LINK_TRANSACTION(16972),
    AGGREGATE_COMPLETE_TRANSACTION(16705),
    AGGREGATE_BONDED_TRANSACTION(16961),
    VOTING_KEY_LINK_TRANSACTION(16707),
    VOTING_KEY_LINK_V1_TRANSACTION(16707),
    VRF_KEY_LINK_TRANSACTION(16963),
    HASH_LOCK_TRANSACTION(16712),
    SECRET_LOCK_TRANSACTION(16722),
    SECRET_PROOF_TRANSACTION(16978),
    ACCOUNT_METADATA_TRANSACTION(16708),
    MOSAIC_METADATA_TRANSACTION(16964),
    NAMESPACE_METADATA_TRANSACTION(17220),
    MOSAIC_DEFINITION_TRANSACTION(16717),
    MOSAIC_SUPPLY_CHANGE_TRANSACTION(16973),
    MULTISIG_ACCOUNT_MODIFICATION_TRANSACTION(16725),
    ADDRESS_ALIAS_TRANSACTION(16974),
    MOSAIC_ALIAS_TRANSACTION(17230),
    NAMESPACE_REGISTRATION_TRANSACTION(16718),
    ACCOUNT_ADDRESS_RESTRICTION_TRANSACTION(16720),
    ACCOUNT_MOSAIC_RESTRICTION_TRANSACTION(16976),
    ACCOUNT_OPERATION_RESTRICTION_TRANSACTION(17232),
    MOSAIC_ADDRESS_RESTRICTION_TRANSACTION(16977),
    MOSAIC_GLOBAL_RESTRICTION_TRANSACTION(16721),
    TRANSFER_TRANSACTION(16724);

    private final short value;

    private EntityTypeDto(short value) {
        this.value = value;
    }

    public static EntityTypeDto rawValueOf(short value) {
        for (EntityTypeDto current : EntityTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for EntityTypeDto.");
    }

    @Override
    public int getSize() {
        return 2;
    }

    public short getValue() {
        return this.value;
    }

    public static EntityTypeDto loadFromBinary(DataInputStream stream) {
        try {
            short streamValue = Short.reverseBytes(stream.readShort());
            return EntityTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeShort(Short.reverseBytes(this.value)));
    }
}

