/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.NodeKeyLinkTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class EmbeddedNodeKeyLinkTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final NodeKeyLinkTransactionBodyBuilder nodeKeyLinkTransactionBody;

    protected EmbeddedNodeKeyLinkTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.nodeKeyLinkTransactionBody = NodeKeyLinkTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedNodeKeyLinkTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedNodeKeyLinkTransactionBuilder(stream);
    }

    protected EmbeddedNodeKeyLinkTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto linkedPublicKey, LinkActionDto linkAction) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.nodeKeyLinkTransactionBody = new NodeKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public static EmbeddedNodeKeyLinkTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new EmbeddedNodeKeyLinkTransactionBuilder(signerPublicKey, version, network, type, linkedPublicKey, linkAction);
    }

    public KeyDto getLinkedPublicKey() {
        return this.nodeKeyLinkTransactionBody.getLinkedPublicKey();
    }

    public LinkActionDto getLinkAction() {
        return this.nodeKeyLinkTransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.nodeKeyLinkTransactionBody.getSize();
    }

    @Override
    public NodeKeyLinkTransactionBodyBuilder getBody() {
        return this.nodeKeyLinkTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.nodeKeyLinkTransactionBody);
        });
    }
}

