/**
*** Copyright (c) 2016-2019, Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp.
*** Copyright (c) 2020-present, Jaguar0625, gimre, BloodyRookie.
***
*** This file is part of Catapult.
***
*** Catapult is free software: you can redistribute it and/or modify
*** it under the terms of the GNU Lesser General Public License as published by
*** the Free Software Foundation, either version 3 of the License, or
*** (at your option) any later version.
***
*** Catapult is distributed in the hope that it will be useful,
*** but WITHOUT ANY WARRANTY; without even the implied warranty of
*** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*** GNU Lesser General Public License for more details.
***
*** You should have received a copy of the GNU Lesser General Public License
*** along with Catapult. If not, see <http://www.gnu.org/licenses/>.
**/

package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Voting key v1. */
public final class VotingKeyV1Dto implements Serializer {
    /** Voting key v1. */
    private final ByteBuffer votingKeyV1;

    /**
     * Constructor.
     *
     * @param votingKeyV1 Voting key v1.
     */
    public VotingKeyV1Dto(final ByteBuffer votingKeyV1) {
        this.votingKeyV1 = votingKeyV1;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public VotingKeyV1Dto(final DataInputStream stream) {
        try {
            this.votingKeyV1 = GeneratorUtils.readByteBuffer(stream, 48);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    /**
     * Gets Voting key v1.
     *
     * @return Voting key v1.
     */
    public ByteBuffer getVotingKeyV1() {
        return this.votingKeyV1;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 48;
    }

    /**
     * Creates an instance of VotingKeyV1Dto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of VotingKeyV1Dto.
     */
    public static VotingKeyV1Dto loadFromBinary(final DataInputStream stream) {
        return new VotingKeyV1Dto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.votingKeyV1.array(), 0, this.votingKeyV1.array().length);
        });
    }
}

