/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.LockHashAlgorithmDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public class SecretLockTransactionBodyBuilder
implements Serializer {
    private final Hash256Dto secret;
    private final UnresolvedMosaicBuilder mosaic;
    private final BlockDurationDto duration;
    private final LockHashAlgorithmDto hashAlgorithm;
    private final UnresolvedAddressDto recipientAddress;

    protected SecretLockTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.secret = Hash256Dto.loadFromBinary(stream);
            this.mosaic = UnresolvedMosaicBuilder.loadFromBinary(stream);
            this.duration = BlockDurationDto.loadFromBinary(stream);
            this.hashAlgorithm = LockHashAlgorithmDto.loadFromBinary(stream);
            this.recipientAddress = UnresolvedAddressDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static SecretLockTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new SecretLockTransactionBodyBuilder(stream);
    }

    protected SecretLockTransactionBodyBuilder(Hash256Dto secret, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, LockHashAlgorithmDto hashAlgorithm, UnresolvedAddressDto recipientAddress) {
        GeneratorUtils.notNull(secret, "secret is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        GeneratorUtils.notNull(hashAlgorithm, "hashAlgorithm is null", new Object[0]);
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        this.secret = secret;
        this.mosaic = mosaic;
        this.duration = duration;
        this.hashAlgorithm = hashAlgorithm;
        this.recipientAddress = recipientAddress;
    }

    public static SecretLockTransactionBodyBuilder create(Hash256Dto secret, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, LockHashAlgorithmDto hashAlgorithm, UnresolvedAddressDto recipientAddress) {
        return new SecretLockTransactionBodyBuilder(secret, mosaic, duration, hashAlgorithm, recipientAddress);
    }

    public Hash256Dto getSecret() {
        return this.secret;
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public BlockDurationDto getDuration() {
        return this.duration;
    }

    public LockHashAlgorithmDto getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.recipientAddress;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.secret.getSize();
        size += this.mosaic.getSize();
        size += this.duration.getSize();
        size += this.hashAlgorithm.getSize();
        return size += this.recipientAddress.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.secret);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
            GeneratorUtils.writeEntity(dataOutputStream, this.duration);
            GeneratorUtils.writeEntity(dataOutputStream, this.hashAlgorithm);
            GeneratorUtils.writeEntity(dataOutputStream, this.recipientAddress);
        });
    }
}

