/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class MultisigEntryBuilder
implements Serializer {
    private final int minApproval;
    private final int minRemoval;
    private final AddressDto accountAddress;
    private final List<AddressDto> cosignatoryAddresses;
    private final List<AddressDto> multisigAddresses;

    protected MultisigEntryBuilder(DataInputStream stream) {
        try {
            this.minApproval = Integer.reverseBytes(stream.readInt());
            this.minRemoval = Integer.reverseBytes(stream.readInt());
            this.accountAddress = AddressDto.loadFromBinary(stream);
            long cosignatoryAddressesCount = Long.reverseBytes(stream.readLong());
            this.cosignatoryAddresses = GeneratorUtils.loadFromBinaryArray(AddressDto::loadFromBinary, stream, cosignatoryAddressesCount);
            long multisigAddressesCount = Long.reverseBytes(stream.readLong());
            this.multisigAddresses = GeneratorUtils.loadFromBinaryArray(AddressDto::loadFromBinary, stream, multisigAddressesCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MultisigEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MultisigEntryBuilder(stream);
    }

    protected MultisigEntryBuilder(int minApproval, int minRemoval, AddressDto accountAddress, List<AddressDto> cosignatoryAddresses, List<AddressDto> multisigAddresses) {
        GeneratorUtils.notNull(minApproval, "minApproval is null", new Object[0]);
        GeneratorUtils.notNull(minRemoval, "minRemoval is null", new Object[0]);
        GeneratorUtils.notNull(accountAddress, "accountAddress is null", new Object[0]);
        GeneratorUtils.notNull(cosignatoryAddresses, "cosignatoryAddresses is null", new Object[0]);
        GeneratorUtils.notNull(multisigAddresses, "multisigAddresses is null", new Object[0]);
        this.minApproval = minApproval;
        this.minRemoval = minRemoval;
        this.accountAddress = accountAddress;
        this.cosignatoryAddresses = cosignatoryAddresses;
        this.multisigAddresses = multisigAddresses;
    }

    public static MultisigEntryBuilder create(int minApproval, int minRemoval, AddressDto accountAddress, List<AddressDto> cosignatoryAddresses, List<AddressDto> multisigAddresses) {
        return new MultisigEntryBuilder(minApproval, minRemoval, accountAddress, cosignatoryAddresses, multisigAddresses);
    }

    public int getMinApproval() {
        return this.minApproval;
    }

    public int getMinRemoval() {
        return this.minRemoval;
    }

    public AddressDto getAccountAddress() {
        return this.accountAddress;
    }

    public List<AddressDto> getCosignatoryAddresses() {
        return this.cosignatoryAddresses;
    }

    public List<AddressDto> getMultisigAddresses() {
        return this.multisigAddresses;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += this.accountAddress.getSize();
        size += 8;
        size += this.cosignatoryAddresses.stream().mapToInt(o -> o.getSize()).sum();
        size += 8;
        return size += this.multisigAddresses.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getMinApproval()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getMinRemoval()));
            GeneratorUtils.writeEntity(dataOutputStream, this.accountAddress);
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getCosignatoryAddresses())));
            GeneratorUtils.writeList(dataOutputStream, this.cosignatoryAddresses);
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getMultisigAddresses())));
            GeneratorUtils.writeList(dataOutputStream, this.multisigAddresses);
        });
    }
}

