/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicAddressRestrictionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicGlobalRestrictionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicRestrictionEntryTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicRestrictionEntryBuilder
implements Serializer {
    private final MosaicRestrictionEntryTypeDto entryType;
    private MosaicAddressRestrictionEntryBuilder addressEntry;
    private MosaicGlobalRestrictionEntryBuilder globalEntry;

    protected MosaicRestrictionEntryBuilder(DataInputStream stream) {
        try {
            this.entryType = MosaicRestrictionEntryTypeDto.loadFromBinary(stream);
            if (this.entryType == MosaicRestrictionEntryTypeDto.ADDRESS) {
                this.addressEntry = MosaicAddressRestrictionEntryBuilder.loadFromBinary(stream);
            }
            if (this.entryType == MosaicRestrictionEntryTypeDto.GLOBAL) {
                this.globalEntry = MosaicGlobalRestrictionEntryBuilder.loadFromBinary(stream);
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicRestrictionEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicRestrictionEntryBuilder(stream);
    }

    protected MosaicRestrictionEntryBuilder(MosaicRestrictionEntryTypeDto entryType, MosaicAddressRestrictionEntryBuilder addressEntry, MosaicGlobalRestrictionEntryBuilder globalEntry) {
        GeneratorUtils.notNull(entryType, "entryType is null", new Object[0]);
        if (entryType == MosaicRestrictionEntryTypeDto.ADDRESS) {
            GeneratorUtils.notNull(addressEntry, "addressEntry is null", new Object[0]);
        }
        if (entryType == MosaicRestrictionEntryTypeDto.GLOBAL) {
            GeneratorUtils.notNull(globalEntry, "globalEntry is null", new Object[0]);
        }
        this.entryType = entryType;
        this.addressEntry = addressEntry;
        this.globalEntry = globalEntry;
    }

    public static MosaicRestrictionEntryBuilder createGlobal(MosaicGlobalRestrictionEntryBuilder globalEntry) {
        MosaicRestrictionEntryTypeDto entryType = MosaicRestrictionEntryTypeDto.GLOBAL;
        return new MosaicRestrictionEntryBuilder(entryType, null, globalEntry);
    }

    public static MosaicRestrictionEntryBuilder createAddress(MosaicAddressRestrictionEntryBuilder addressEntry) {
        MosaicRestrictionEntryTypeDto entryType = MosaicRestrictionEntryTypeDto.ADDRESS;
        return new MosaicRestrictionEntryBuilder(entryType, addressEntry, null);
    }

    public MosaicRestrictionEntryTypeDto getEntryType() {
        return this.entryType;
    }

    public MosaicAddressRestrictionEntryBuilder getAddressEntry() {
        if (this.entryType != MosaicRestrictionEntryTypeDto.ADDRESS) {
            throw new IllegalStateException("entryType is not set to ADDRESS.");
        }
        return this.addressEntry;
    }

    public MosaicGlobalRestrictionEntryBuilder getGlobalEntry() {
        if (this.entryType != MosaicRestrictionEntryTypeDto.GLOBAL) {
            throw new IllegalStateException("entryType is not set to GLOBAL.");
        }
        return this.globalEntry;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.entryType.getSize();
        if (this.entryType == MosaicRestrictionEntryTypeDto.ADDRESS) {
            size += this.addressEntry.getSize();
        }
        if (this.entryType == MosaicRestrictionEntryTypeDto.GLOBAL) {
            size += this.globalEntry.getSize();
        }
        return size;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.entryType);
            if (this.entryType == MosaicRestrictionEntryTypeDto.ADDRESS) {
                GeneratorUtils.writeEntity(dataOutputStream, this.addressEntry);
            }
            if (this.entryType == MosaicRestrictionEntryTypeDto.GLOBAL) {
                GeneratorUtils.writeEntity(dataOutputStream, this.globalEntry);
            }
        });
    }
}

