/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MetadataTypeDto;
import io.nem.symbol.catapult.builders.MetadataValueBuilder;
import io.nem.symbol.catapult.builders.ScopedMetadataKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MetadataEntryBuilder
implements Serializer {
    private final AddressDto sourceAddress;
    private final AddressDto targetAddress;
    private final ScopedMetadataKeyDto scopedMetadataKey;
    private final long targetId;
    private final MetadataTypeDto metadataType;
    private final MetadataValueBuilder value;

    protected MetadataEntryBuilder(DataInputStream stream) {
        try {
            this.sourceAddress = AddressDto.loadFromBinary(stream);
            this.targetAddress = AddressDto.loadFromBinary(stream);
            this.scopedMetadataKey = ScopedMetadataKeyDto.loadFromBinary(stream);
            this.targetId = Long.reverseBytes(stream.readLong());
            this.metadataType = MetadataTypeDto.loadFromBinary(stream);
            this.value = MetadataValueBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MetadataEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MetadataEntryBuilder(stream);
    }

    protected MetadataEntryBuilder(AddressDto sourceAddress, AddressDto targetAddress, ScopedMetadataKeyDto scopedMetadataKey, long targetId, MetadataTypeDto metadataType, MetadataValueBuilder value) {
        GeneratorUtils.notNull(sourceAddress, "sourceAddress is null", new Object[0]);
        GeneratorUtils.notNull(targetAddress, "targetAddress is null", new Object[0]);
        GeneratorUtils.notNull(scopedMetadataKey, "scopedMetadataKey is null", new Object[0]);
        GeneratorUtils.notNull(targetId, "targetId is null", new Object[0]);
        GeneratorUtils.notNull(metadataType, "metadataType is null", new Object[0]);
        GeneratorUtils.notNull(value, "value is null", new Object[0]);
        this.sourceAddress = sourceAddress;
        this.targetAddress = targetAddress;
        this.scopedMetadataKey = scopedMetadataKey;
        this.targetId = targetId;
        this.metadataType = metadataType;
        this.value = value;
    }

    public static MetadataEntryBuilder create(AddressDto sourceAddress, AddressDto targetAddress, ScopedMetadataKeyDto scopedMetadataKey, long targetId, MetadataTypeDto metadataType, MetadataValueBuilder value) {
        return new MetadataEntryBuilder(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, value);
    }

    public AddressDto getSourceAddress() {
        return this.sourceAddress;
    }

    public AddressDto getTargetAddress() {
        return this.targetAddress;
    }

    public ScopedMetadataKeyDto getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public MetadataTypeDto getMetadataType() {
        return this.metadataType;
    }

    public MetadataValueBuilder getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.sourceAddress.getSize();
        size += this.targetAddress.getSize();
        size += this.scopedMetadataKey.getSize();
        size += 8;
        size += this.metadataType.getSize();
        return size += this.value.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.sourceAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.targetAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.scopedMetadataKey);
            dataOutputStream.writeLong(Long.reverseBytes(this.getTargetId()));
            GeneratorUtils.writeEntity(dataOutputStream, this.metadataType);
            GeneratorUtils.writeEntity(dataOutputStream, this.value);
        });
    }
}

