/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicRestrictionKeyDto;
import io.nem.symbol.catapult.builders.RestrictionRuleBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class GlobalKeyValueBuilder
implements Serializer {
    private final MosaicRestrictionKeyDto key;
    private final RestrictionRuleBuilder restrictionRule;

    protected GlobalKeyValueBuilder(DataInputStream stream) {
        try {
            this.key = MosaicRestrictionKeyDto.loadFromBinary(stream);
            this.restrictionRule = RestrictionRuleBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static GlobalKeyValueBuilder loadFromBinary(DataInputStream stream) {
        return new GlobalKeyValueBuilder(stream);
    }

    protected GlobalKeyValueBuilder(MosaicRestrictionKeyDto key, RestrictionRuleBuilder restrictionRule) {
        GeneratorUtils.notNull(key, "key is null", new Object[0]);
        GeneratorUtils.notNull(restrictionRule, "restrictionRule is null", new Object[0]);
        this.key = key;
        this.restrictionRule = restrictionRule;
    }

    public static GlobalKeyValueBuilder create(MosaicRestrictionKeyDto key, RestrictionRuleBuilder restrictionRule) {
        return new GlobalKeyValueBuilder(key, restrictionRule);
    }

    public MosaicRestrictionKeyDto getKey() {
        return this.key;
    }

    public RestrictionRuleBuilder getRestrictionRule() {
        return this.restrictionRule;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.key.getSize();
        return size += this.restrictionRule.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.key);
            GeneratorUtils.writeEntity(dataOutputStream, this.restrictionRule);
        });
    }
}

