/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicRestrictionKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class AddressKeyValueBuilder
implements Serializer {
    private final MosaicRestrictionKeyDto key;
    private final long value;

    protected AddressKeyValueBuilder(DataInputStream stream) {
        try {
            this.key = MosaicRestrictionKeyDto.loadFromBinary(stream);
            this.value = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AddressKeyValueBuilder loadFromBinary(DataInputStream stream) {
        return new AddressKeyValueBuilder(stream);
    }

    protected AddressKeyValueBuilder(MosaicRestrictionKeyDto key, long value) {
        GeneratorUtils.notNull(key, "key is null", new Object[0]);
        GeneratorUtils.notNull(value, "value is null", new Object[0]);
        this.key = key;
        this.value = value;
    }

    public static AddressKeyValueBuilder create(MosaicRestrictionKeyDto key, long value) {
        return new AddressKeyValueBuilder(key, value);
    }

    public MosaicRestrictionKeyDto getKey() {
        return this.key;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.key.getSize();
        return size += 8;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.key);
            dataOutputStream.writeLong(Long.reverseBytes(this.getValue()));
        });
    }
}

