/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountRestrictionFlagsDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.util.EnumSet;
import java.util.List;

public class AccountAddressRestrictionTransactionBodyBuilder
implements Serializer {
    private final EnumSet<AccountRestrictionFlagsDto> restrictionFlags;
    private final int accountRestrictionTransactionBody_Reserved1;
    private final List<UnresolvedAddressDto> restrictionAdditions;
    private final List<UnresolvedAddressDto> restrictionDeletions;

    protected AccountAddressRestrictionTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.restrictionFlags = GeneratorUtils.toSet(AccountRestrictionFlagsDto.class, Short.reverseBytes(stream.readShort()));
            byte restrictionAdditionsCount = stream.readByte();
            byte restrictionDeletionsCount = stream.readByte();
            this.accountRestrictionTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.restrictionAdditions = GeneratorUtils.loadFromBinaryArray(UnresolvedAddressDto::loadFromBinary, stream, restrictionAdditionsCount);
            this.restrictionDeletions = GeneratorUtils.loadFromBinaryArray(UnresolvedAddressDto::loadFromBinary, stream, restrictionDeletionsCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountAddressRestrictionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountAddressRestrictionTransactionBodyBuilder(stream);
    }

    protected AccountAddressRestrictionTransactionBodyBuilder(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedAddressDto> restrictionAdditions, List<UnresolvedAddressDto> restrictionDeletions) {
        GeneratorUtils.notNull(restrictionFlags, "restrictionFlags is null", new Object[0]);
        GeneratorUtils.notNull(restrictionAdditions, "restrictionAdditions is null", new Object[0]);
        GeneratorUtils.notNull(restrictionDeletions, "restrictionDeletions is null", new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.accountRestrictionTransactionBody_Reserved1 = 0;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountAddressRestrictionTransactionBodyBuilder create(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedAddressDto> restrictionAdditions, List<UnresolvedAddressDto> restrictionDeletions) {
        return new AccountAddressRestrictionTransactionBodyBuilder(restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public EnumSet<AccountRestrictionFlagsDto> getRestrictionFlags() {
        return this.restrictionFlags;
    }

    private int getAccountRestrictionTransactionBody_Reserved1() {
        return this.accountRestrictionTransactionBody_Reserved1;
    }

    public List<UnresolvedAddressDto> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<UnresolvedAddressDto> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += AccountRestrictionFlagsDto.values()[0].getSize();
        ++size;
        ++size;
        size += 4;
        size += this.restrictionAdditions.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.restrictionDeletions.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.toLong(AccountRestrictionFlagsDto.class, this.restrictionFlags)));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getRestrictionAdditions()));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getRestrictionDeletions()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getAccountRestrictionTransactionBody_Reserved1()));
            GeneratorUtils.writeList(dataOutputStream, this.restrictionAdditions);
            GeneratorUtils.writeList(dataOutputStream, this.restrictionDeletions);
        });
    }
}

