/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class ProofVerificationHashDto
implements Serializer {
    private final ByteBuffer proofVerificationHash;

    public ProofVerificationHashDto(ByteBuffer proofVerificationHash) {
        this.proofVerificationHash = proofVerificationHash;
    }

    public ProofVerificationHashDto(DataInputStream stream) {
        try {
            this.proofVerificationHash = GeneratorUtils.readByteBuffer(stream, 16);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getProofVerificationHash() {
        return this.proofVerificationHash;
    }

    @Override
    public int getSize() {
        return 16;
    }

    public static ProofVerificationHashDto loadFromBinary(DataInputStream stream) {
        return new ProofVerificationHashDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.proofVerificationHash.array(), 0, this.proofVerificationHash.array().length));
    }
}

