/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class HeightActivityBucketsBuilder
implements Serializer {
    private final ByteBuffer buckets;

    protected HeightActivityBucketsBuilder(DataInputStream stream) {
        try {
            this.buckets = GeneratorUtils.readByteBuffer(stream, 5);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static HeightActivityBucketsBuilder loadFromBinary(DataInputStream stream) {
        return new HeightActivityBucketsBuilder(stream);
    }

    protected HeightActivityBucketsBuilder(ByteBuffer buckets) {
        GeneratorUtils.notNull(buckets, "buckets is null", new Object[0]);
        this.buckets = buckets;
    }

    public static HeightActivityBucketsBuilder create(ByteBuffer buckets) {
        return new HeightActivityBucketsBuilder(buckets);
    }

    public ByteBuffer getBuckets() {
        return this.buckets;
    }

    @Override
    public int getSize() {
        int size = 0;
        return size += this.buckets.array().length;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.buckets.array(), 0, this.buckets.array().length));
    }
}

