/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public class HashLockTransactionBodyBuilder
implements Serializer {
    private final UnresolvedMosaicBuilder mosaic;
    private final BlockDurationDto duration;
    private final Hash256Dto hash;

    protected HashLockTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.mosaic = UnresolvedMosaicBuilder.loadFromBinary(stream);
            this.duration = BlockDurationDto.loadFromBinary(stream);
            this.hash = Hash256Dto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static HashLockTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new HashLockTransactionBodyBuilder(stream);
    }

    protected HashLockTransactionBodyBuilder(UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        GeneratorUtils.notNull(hash, "hash is null", new Object[0]);
        this.mosaic = mosaic;
        this.duration = duration;
        this.hash = hash;
    }

    public static HashLockTransactionBodyBuilder create(UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        return new HashLockTransactionBodyBuilder(mosaic, duration, hash);
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public BlockDurationDto getDuration() {
        return this.duration;
    }

    public Hash256Dto getHash() {
        return this.hash;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaic.getSize();
        size += this.duration.getSize();
        return size += this.hash.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
            GeneratorUtils.writeEntity(dataOutputStream, this.duration);
            GeneratorUtils.writeEntity(dataOutputStream, this.hash);
        });
    }
}

