/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.VotingKeyDto;
import java.io.DataInputStream;

public class VotingKeyLinkTransactionBodyBuilder
implements Serializer {
    private final VotingKeyDto linkedPublicKey;
    private final LinkActionDto linkAction;

    protected VotingKeyLinkTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.linkedPublicKey = VotingKeyDto.loadFromBinary(stream);
            this.linkAction = LinkActionDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static VotingKeyLinkTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new VotingKeyLinkTransactionBodyBuilder(stream);
    }

    protected VotingKeyLinkTransactionBodyBuilder(VotingKeyDto linkedPublicKey, LinkActionDto linkAction) {
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.linkAction = linkAction;
    }

    public static VotingKeyLinkTransactionBodyBuilder create(VotingKeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new VotingKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public VotingKeyDto getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkActionDto getLinkAction() {
        return this.linkAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.linkedPublicKey.getSize();
        return size += this.linkAction.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.linkedPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.linkAction);
        });
    }
}

