/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.MosaicRestrictionTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class RestrictionRuleBuilder
implements Serializer {
    private final MosaicIdDto referenceMosaicId;
    private final long restrictionValue;
    private final MosaicRestrictionTypeDto restrictionType;

    protected RestrictionRuleBuilder(DataInputStream stream) {
        try {
            this.referenceMosaicId = MosaicIdDto.loadFromBinary(stream);
            this.restrictionValue = Long.reverseBytes(stream.readLong());
            this.restrictionType = MosaicRestrictionTypeDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static RestrictionRuleBuilder loadFromBinary(DataInputStream stream) {
        return new RestrictionRuleBuilder(stream);
    }

    protected RestrictionRuleBuilder(MosaicIdDto referenceMosaicId, long restrictionValue, MosaicRestrictionTypeDto restrictionType) {
        GeneratorUtils.notNull(referenceMosaicId, "referenceMosaicId is null", new Object[0]);
        GeneratorUtils.notNull(restrictionValue, "restrictionValue is null", new Object[0]);
        GeneratorUtils.notNull(restrictionType, "restrictionType is null", new Object[0]);
        this.referenceMosaicId = referenceMosaicId;
        this.restrictionValue = restrictionValue;
        this.restrictionType = restrictionType;
    }

    public static RestrictionRuleBuilder create(MosaicIdDto referenceMosaicId, long restrictionValue, MosaicRestrictionTypeDto restrictionType) {
        return new RestrictionRuleBuilder(referenceMosaicId, restrictionValue, restrictionType);
    }

    public MosaicIdDto getReferenceMosaicId() {
        return this.referenceMosaicId;
    }

    public long getRestrictionValue() {
        return this.restrictionValue;
    }

    public MosaicRestrictionTypeDto getRestrictionType() {
        return this.restrictionType;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.referenceMosaicId.getSize();
        size += 8;
        return size += this.restrictionType.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.referenceMosaicId);
            dataOutputStream.writeLong(Long.reverseBytes(this.getRestrictionValue()));
            GeneratorUtils.writeEntity(dataOutputStream, this.restrictionType);
        });
    }
}

