/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class MultisigEntryBuilder
implements Serializer {
    private final int minApproval;
    private final int minRemoval;
    private final KeyDto accountPublicKey;
    private final List<KeyDto> cosignatoryPublicKeys;
    private final List<KeyDto> multisigPublicKeys;

    protected MultisigEntryBuilder(DataInputStream stream) {
        try {
            this.minApproval = Integer.reverseBytes(stream.readInt());
            this.minRemoval = Integer.reverseBytes(stream.readInt());
            this.accountPublicKey = KeyDto.loadFromBinary(stream);
            long cosignatoryPublicKeysCount = Long.reverseBytes(stream.readLong());
            this.cosignatoryPublicKeys = GeneratorUtils.loadFromBinaryArray(KeyDto::loadFromBinary, stream, cosignatoryPublicKeysCount);
            long multisigPublicKeysCount = Long.reverseBytes(stream.readLong());
            this.multisigPublicKeys = GeneratorUtils.loadFromBinaryArray(KeyDto::loadFromBinary, stream, multisigPublicKeysCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MultisigEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MultisigEntryBuilder(stream);
    }

    protected MultisigEntryBuilder(int minApproval, int minRemoval, KeyDto accountPublicKey, List<KeyDto> cosignatoryPublicKeys, List<KeyDto> multisigPublicKeys) {
        GeneratorUtils.notNull(minApproval, "minApproval is null", new Object[0]);
        GeneratorUtils.notNull(minRemoval, "minRemoval is null", new Object[0]);
        GeneratorUtils.notNull(accountPublicKey, "accountPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(cosignatoryPublicKeys, "cosignatoryPublicKeys is null", new Object[0]);
        GeneratorUtils.notNull(multisigPublicKeys, "multisigPublicKeys is null", new Object[0]);
        this.minApproval = minApproval;
        this.minRemoval = minRemoval;
        this.accountPublicKey = accountPublicKey;
        this.cosignatoryPublicKeys = cosignatoryPublicKeys;
        this.multisigPublicKeys = multisigPublicKeys;
    }

    public static MultisigEntryBuilder create(int minApproval, int minRemoval, KeyDto accountPublicKey, List<KeyDto> cosignatoryPublicKeys, List<KeyDto> multisigPublicKeys) {
        return new MultisigEntryBuilder(minApproval, minRemoval, accountPublicKey, cosignatoryPublicKeys, multisigPublicKeys);
    }

    public int getMinApproval() {
        return this.minApproval;
    }

    public int getMinRemoval() {
        return this.minRemoval;
    }

    public KeyDto getAccountPublicKey() {
        return this.accountPublicKey;
    }

    public List<KeyDto> getCosignatoryPublicKeys() {
        return this.cosignatoryPublicKeys;
    }

    public List<KeyDto> getMultisigPublicKeys() {
        return this.multisigPublicKeys;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += this.accountPublicKey.getSize();
        size += 8;
        size += this.cosignatoryPublicKeys.stream().mapToInt(o -> o.getSize()).sum();
        size += 8;
        return size += this.multisigPublicKeys.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getMinApproval()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getMinRemoval()));
            GeneratorUtils.writeEntity(dataOutputStream, this.accountPublicKey);
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getCosignatoryPublicKeys())));
            GeneratorUtils.writeList(dataOutputStream, this.cosignatoryPublicKeys);
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getMultisigPublicKeys())));
            GeneratorUtils.writeList(dataOutputStream, this.multisigPublicKeys);
        });
    }
}

