/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicDefinitionBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicEntryBuilder
implements Serializer {
    private final MosaicIdDto mosaicId;
    private final AmountDto supply;
    private final MosaicDefinitionBuilder definition;

    protected MosaicEntryBuilder(DataInputStream stream) {
        try {
            this.mosaicId = MosaicIdDto.loadFromBinary(stream);
            this.supply = AmountDto.loadFromBinary(stream);
            this.definition = MosaicDefinitionBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicEntryBuilder(stream);
    }

    protected MosaicEntryBuilder(MosaicIdDto mosaicId, AmountDto supply, MosaicDefinitionBuilder definition) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(supply, "supply is null", new Object[0]);
        GeneratorUtils.notNull(definition, "definition is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.supply = supply;
        this.definition = definition;
    }

    public static MosaicEntryBuilder create(MosaicIdDto mosaicId, AmountDto supply, MosaicDefinitionBuilder definition) {
        return new MosaicEntryBuilder(mosaicId, supply, definition);
    }

    public MosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public AmountDto getSupply() {
        return this.supply;
    }

    public MosaicDefinitionBuilder getDefinition() {
        return this.definition;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        size += this.supply.getSize();
        return size += this.definition.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaicId);
            GeneratorUtils.writeEntity(dataOutputStream, this.supply);
            GeneratorUtils.writeEntity(dataOutputStream, this.definition);
        });
    }
}

