/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MetadataTypeDto;
import io.nem.symbol.catapult.builders.MetadataValueBuilder;
import io.nem.symbol.catapult.builders.ScopedMetadataKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MetadataEntryBuilder
implements Serializer {
    private final KeyDto sourcePublicKey;
    private final KeyDto targetPublicKey;
    private final ScopedMetadataKeyDto scopedMetadataKey;
    private final long targetId;
    private final MetadataTypeDto metadataType;
    private final MetadataValueBuilder value;

    protected MetadataEntryBuilder(DataInputStream stream) {
        try {
            this.sourcePublicKey = KeyDto.loadFromBinary(stream);
            this.targetPublicKey = KeyDto.loadFromBinary(stream);
            this.scopedMetadataKey = ScopedMetadataKeyDto.loadFromBinary(stream);
            this.targetId = Long.reverseBytes(stream.readLong());
            this.metadataType = MetadataTypeDto.loadFromBinary(stream);
            this.value = MetadataValueBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MetadataEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MetadataEntryBuilder(stream);
    }

    protected MetadataEntryBuilder(KeyDto sourcePublicKey, KeyDto targetPublicKey, ScopedMetadataKeyDto scopedMetadataKey, long targetId, MetadataTypeDto metadataType, MetadataValueBuilder value) {
        GeneratorUtils.notNull(sourcePublicKey, "sourcePublicKey is null", new Object[0]);
        GeneratorUtils.notNull(targetPublicKey, "targetPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(scopedMetadataKey, "scopedMetadataKey is null", new Object[0]);
        GeneratorUtils.notNull(targetId, "targetId is null", new Object[0]);
        GeneratorUtils.notNull(metadataType, "metadataType is null", new Object[0]);
        GeneratorUtils.notNull(value, "value is null", new Object[0]);
        this.sourcePublicKey = sourcePublicKey;
        this.targetPublicKey = targetPublicKey;
        this.scopedMetadataKey = scopedMetadataKey;
        this.targetId = targetId;
        this.metadataType = metadataType;
        this.value = value;
    }

    public static MetadataEntryBuilder create(KeyDto sourcePublicKey, KeyDto targetPublicKey, ScopedMetadataKeyDto scopedMetadataKey, long targetId, MetadataTypeDto metadataType, MetadataValueBuilder value) {
        return new MetadataEntryBuilder(sourcePublicKey, targetPublicKey, scopedMetadataKey, targetId, metadataType, value);
    }

    public KeyDto getSourcePublicKey() {
        return this.sourcePublicKey;
    }

    public KeyDto getTargetPublicKey() {
        return this.targetPublicKey;
    }

    public ScopedMetadataKeyDto getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public MetadataTypeDto getMetadataType() {
        return this.metadataType;
    }

    public MetadataValueBuilder getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.sourcePublicKey.getSize();
        size += this.targetPublicKey.getSize();
        size += this.scopedMetadataKey.getSize();
        size += 8;
        size += this.metadataType.getSize();
        return size += this.value.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.sourcePublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.targetPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.scopedMetadataKey);
            dataOutputStream.writeLong(Long.reverseBytes(this.getTargetId()));
            GeneratorUtils.writeEntity(dataOutputStream, this.metadataType);
            GeneratorUtils.writeEntity(dataOutputStream, this.value);
        });
    }
}

