/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.VotingKeyDto;
import io.nem.symbol.catapult.builders.VotingKeyLinkTransactionBodyBuilder;
import java.io.DataInputStream;

public class EmbeddedVotingKeyLinkTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final VotingKeyLinkTransactionBodyBuilder votingKeyLinkTransactionBody;

    protected EmbeddedVotingKeyLinkTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.votingKeyLinkTransactionBody = VotingKeyLinkTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedVotingKeyLinkTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedVotingKeyLinkTransactionBuilder(stream);
    }

    protected EmbeddedVotingKeyLinkTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, VotingKeyDto linkedPublicKey, LinkActionDto linkAction) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.votingKeyLinkTransactionBody = new VotingKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public static EmbeddedVotingKeyLinkTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, VotingKeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new EmbeddedVotingKeyLinkTransactionBuilder(signerPublicKey, version, network, type, linkedPublicKey, linkAction);
    }

    public VotingKeyDto getLinkedPublicKey() {
        return this.votingKeyLinkTransactionBody.getLinkedPublicKey();
    }

    public LinkActionDto getLinkAction() {
        return this.votingKeyLinkTransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.votingKeyLinkTransactionBody.getSize();
    }

    @Override
    public VotingKeyLinkTransactionBodyBuilder getBody() {
        return this.votingKeyLinkTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.votingKeyLinkTransactionBody);
        });
    }
}

