/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceMetadataTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class EmbeddedNamespaceMetadataTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final NamespaceMetadataTransactionBodyBuilder namespaceMetadataTransactionBody;

    protected EmbeddedNamespaceMetadataTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.namespaceMetadataTransactionBody = NamespaceMetadataTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedNamespaceMetadataTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedNamespaceMetadataTransactionBuilder(stream);
    }

    protected EmbeddedNamespaceMetadataTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, NamespaceIdDto targetNamespaceId, short valueSizeDelta, ByteBuffer value) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(targetPublicKey, "targetPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(scopedMetadataKey, "scopedMetadataKey is null", new Object[0]);
        GeneratorUtils.notNull(targetNamespaceId, "targetNamespaceId is null", new Object[0]);
        GeneratorUtils.notNull(valueSizeDelta, "valueSizeDelta is null", new Object[0]);
        GeneratorUtils.notNull(value, "value is null", new Object[0]);
        this.namespaceMetadataTransactionBody = new NamespaceMetadataTransactionBodyBuilder(targetPublicKey, scopedMetadataKey, targetNamespaceId, valueSizeDelta, value);
    }

    public static EmbeddedNamespaceMetadataTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, NamespaceIdDto targetNamespaceId, short valueSizeDelta, ByteBuffer value) {
        return new EmbeddedNamespaceMetadataTransactionBuilder(signerPublicKey, version, network, type, targetPublicKey, scopedMetadataKey, targetNamespaceId, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.namespaceMetadataTransactionBody.getTargetPublicKey();
    }

    public long getScopedMetadataKey() {
        return this.namespaceMetadataTransactionBody.getScopedMetadataKey();
    }

    public NamespaceIdDto getTargetNamespaceId() {
        return this.namespaceMetadataTransactionBody.getTargetNamespaceId();
    }

    public short getValueSizeDelta() {
        return this.namespaceMetadataTransactionBody.getValueSizeDelta();
    }

    public ByteBuffer getValue() {
        return this.namespaceMetadataTransactionBody.getValue();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.namespaceMetadataTransactionBody.getSize();
    }

    @Override
    public NamespaceMetadataTransactionBodyBuilder getBody() {
        return this.namespaceMetadataTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.namespaceMetadataTransactionBody);
        });
    }
}

