/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class MultisigAccountModificationTransactionBodyBuilder
implements Serializer {
    private final byte minRemovalDelta;
    private final byte minApprovalDelta;
    private final int multisigAccountModificationTransactionBody_Reserved1;
    private final List<KeyDto> publicKeyAdditions;
    private final List<KeyDto> publicKeyDeletions;

    protected MultisigAccountModificationTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.minRemovalDelta = stream.readByte();
            this.minApprovalDelta = stream.readByte();
            byte publicKeyAdditionsCount = stream.readByte();
            byte publicKeyDeletionsCount = stream.readByte();
            this.multisigAccountModificationTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.publicKeyAdditions = GeneratorUtils.loadFromBinaryArray(KeyDto::loadFromBinary, stream, publicKeyAdditionsCount);
            this.publicKeyDeletions = GeneratorUtils.loadFromBinaryArray(KeyDto::loadFromBinary, stream, publicKeyDeletionsCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MultisigAccountModificationTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MultisigAccountModificationTransactionBodyBuilder(stream);
    }

    protected MultisigAccountModificationTransactionBodyBuilder(byte minRemovalDelta, byte minApprovalDelta, List<KeyDto> publicKeyAdditions, List<KeyDto> publicKeyDeletions) {
        GeneratorUtils.notNull(minRemovalDelta, "minRemovalDelta is null", new Object[0]);
        GeneratorUtils.notNull(minApprovalDelta, "minApprovalDelta is null", new Object[0]);
        GeneratorUtils.notNull(publicKeyAdditions, "publicKeyAdditions is null", new Object[0]);
        GeneratorUtils.notNull(publicKeyDeletions, "publicKeyDeletions is null", new Object[0]);
        this.minRemovalDelta = minRemovalDelta;
        this.minApprovalDelta = minApprovalDelta;
        this.multisigAccountModificationTransactionBody_Reserved1 = 0;
        this.publicKeyAdditions = publicKeyAdditions;
        this.publicKeyDeletions = publicKeyDeletions;
    }

    public static MultisigAccountModificationTransactionBodyBuilder create(byte minRemovalDelta, byte minApprovalDelta, List<KeyDto> publicKeyAdditions, List<KeyDto> publicKeyDeletions) {
        return new MultisigAccountModificationTransactionBodyBuilder(minRemovalDelta, minApprovalDelta, publicKeyAdditions, publicKeyDeletions);
    }

    public byte getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public byte getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    public int getMultisigAccountModificationTransactionBody_Reserved1() {
        return this.multisigAccountModificationTransactionBody_Reserved1;
    }

    public List<KeyDto> getPublicKeyAdditions() {
        return this.publicKeyAdditions;
    }

    public List<KeyDto> getPublicKeyDeletions() {
        return this.publicKeyDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        ++size;
        ++size;
        ++size;
        ++size;
        size += 4;
        size += this.publicKeyAdditions.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.publicKeyDeletions.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte(this.getMinRemovalDelta());
            dataOutputStream.writeByte(this.getMinApprovalDelta());
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getPublicKeyAdditions()));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getPublicKeyDeletions()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getMultisigAccountModificationTransactionBody_Reserved1()));
            GeneratorUtils.writeList(dataOutputStream, this.publicKeyAdditions);
            GeneratorUtils.writeList(dataOutputStream, this.publicKeyDeletions);
        });
    }
}

