/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicPropertiesBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicDefinitionBuilder
implements Serializer {
    private final HeightDto startHeight;
    private final KeyDto ownerPublicKey;
    private final int revision;
    private final MosaicPropertiesBuilder properties;

    protected MosaicDefinitionBuilder(DataInputStream stream) {
        try {
            this.startHeight = HeightDto.loadFromBinary(stream);
            this.ownerPublicKey = KeyDto.loadFromBinary(stream);
            this.revision = Integer.reverseBytes(stream.readInt());
            this.properties = MosaicPropertiesBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicDefinitionBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicDefinitionBuilder(stream);
    }

    protected MosaicDefinitionBuilder(HeightDto startHeight, KeyDto ownerPublicKey, int revision, MosaicPropertiesBuilder properties) {
        GeneratorUtils.notNull(startHeight, "startHeight is null", new Object[0]);
        GeneratorUtils.notNull(ownerPublicKey, "ownerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(revision, "revision is null", new Object[0]);
        GeneratorUtils.notNull(properties, "properties is null", new Object[0]);
        this.startHeight = startHeight;
        this.ownerPublicKey = ownerPublicKey;
        this.revision = revision;
        this.properties = properties;
    }

    public static MosaicDefinitionBuilder create(HeightDto startHeight, KeyDto ownerPublicKey, int revision, MosaicPropertiesBuilder properties) {
        return new MosaicDefinitionBuilder(startHeight, ownerPublicKey, revision, properties);
    }

    public HeightDto getStartHeight() {
        return this.startHeight;
    }

    public KeyDto getOwnerPublicKey() {
        return this.ownerPublicKey;
    }

    public int getRevision() {
        return this.revision;
    }

    public MosaicPropertiesBuilder getProperties() {
        return this.properties;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.startHeight.getSize();
        size += this.ownerPublicKey.getSize();
        size += 4;
        return size += this.properties.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.startHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.ownerPublicKey);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getRevision()));
            GeneratorUtils.writeEntity(dataOutputStream, this.properties);
        });
    }
}

